from flask import Flask, jsonify
import os
import psutil
import time
#from threading import Thread
import threading

app = Flask(__name__)

# 全局变量存储最新网速
current_speed = {"dSpeed": 100.0, "uSpeed": 200.0}

# 获取 CPU 使用率
def get_cpu_usage():
    return psutil.cpu_percent(interval=1)

# 获取内存使用情况
def get_memory_usage():
    memory = psutil.virtual_memory()
    #return memory.percent
    return int(((memory.total - memory.available) / (memory.total + 682308403)) *100)
    '''
    return {
        "total": memory.total,
        "available": memory.available,
        "free": memory.free,
        "used": memory.used,
        #"percent": memory.percent
        "percent": int(((memory.total - memory.available) / (memory.total + 682308403)) *100) / 100
    }
    '''
    
# 获取 CPU 温度
def get_cpu_temperature():
    try:
        with open("/sys/class/thermal/thermal_zone0/temp", "r") as f:
            temp = f.read().strip()
        return float(temp) / 1000  # 温度单位转换为摄氏度
    except:
        return None

# 获取网络上行网速
def update_network_speed():
    """后台线程：每秒更新网速"""
    global current_speed
    while True:
        net_io_start = psutil.net_io_counters()
        prev_rx = net_io_start.bytes_recv
        prev_tx = net_io_start.bytes_sent
        start_time = time.time()
        
        time.sleep(1)  # 等待1秒
        
        net_io_end = psutil.net_io_counters()
        current_rx = net_io_end.bytes_recv
        current_tx = net_io_end.bytes_sent
        elapsed = time.time() - start_time
        
        # 更新全局变量
        current_speed["dSpeed"] = round((current_rx - prev_rx) / elapsed, 2)  # KB/s
        current_speed["uSpeed"] = round((current_tx - prev_tx) / elapsed ,2)  # KB/s

# 启动后台线程
#Thread(target=update_network_speed, daemon=True).start()
# 后台线程
thread = threading.Thread(target=update_network_speed)
thread.start()

'''
# 获取网络上行网速
def get_network_speed_up():
    net_io = psutil.net_io_counters()
    return net_io.bytes_sent

# 获取网络下行网速
def get_network_speed_down():
    net_io = psutil.net_io_counters()
    return net_io.bytes_recv
'''
@app.route("/system_stats", methods=["GET"])
def system_stats():
    # 获取系统信息
    stats = {
        "cpuPer": get_cpu_usage(),
        "cpuTemp": get_cpu_temperature(),
        "ramPer": get_memory_usage(),
        #"network": get_network_speed()
        "dSpeed": current_speed["dSpeed"],
        "uSpeed": current_speed["uSpeed"]
    }
    
    # 返回 JSON 格式的数据
    return jsonify(stats)

if __name__ == "__main__":
    app.run(host="0.0.0.0", port=5000, debug=True)  # 在所有网络接口上监听 5000 端口
